import os
import json

# Исходная папка с JSON файлами
source_folder = os.getcwd()
# Имя нового файла
output_filename = 'paper3.json'
# Путь к новому файлу
output_filepath = os.path.join(source_folder, output_filename)

# Список для overrides
overrides = []

# Проходим по всем файлам в исходной папке
for index, filename in enumerate(os.listdir(source_folder), start=82):
    if filename.endswith('.json') and filename != output_filename:
        # Имя файла без расширения
        file_name_without_extension = os.path.splitext(filename)[0]
        
        # Создаем элемент overrides
        override = {
            "predicate": { "custom_model_data": index },
            "model": f"block/{file_name_without_extension}"
        }
        
        # Добавляем элемент в список overrides
        overrides.append(override)

# Создаем содержимое нового JSON файла
new_content = {
    "parent": "item/generated",
    "textures": {
        "layer0": "item/paper"
    },
    "overrides": overrides
}

# Записываем содержимое в новый файл
with open(output_filepath, 'w') as output_file:
    json.dump(new_content, output_file, indent=4)

print(f"Файл {output_filename} успешно создан.")
