#version 150

#moj_import <fog.glsl>
#moj_import <rain_utils.glsl>
#moj_import <emissive_utils.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec2 texCoord0;
in vec4 vertexColor;
in vec4 lightColor;
in vec4 faceLightColor;

// Rain vertex shader vars
in float isRain;
in float rainAlpha;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
	vec4 rainColor = texture(Sampler0, texCoord0, 0.0); // Gets particle's texture without other colors applied to it
	
	float alphaRain = textureLod(Sampler0, texCoord0, 0.0).a * 255.0; // Re-grabs rain texture alpha
	int alphaEmissive = int(round(textureLod(Sampler0, texCoord0, 0.0).a * 255.0));
	
	if (isRain > 0.5 && check_alpha(alphaRain, rainAlpha)) { // rainAlpha = 38%
		if (check_rainBG(rainColor)) discard; // Discards green BG in rain texture
	} else {
		color = make_emissive_particle(color, lightColor, vec4(1.0), alphaEmissive);
	}
	
    if (color.a < 0.1) {
        discard;
    }
	
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
