#version 150

// Using ShockMicro's Emission code!
// Checking for the exact alpha value breaks things, so I use this function to cut down on space while also making it work better.
bool check_alpha(float textureAlpha, float targetAlpha) {
	
	float targetLess = targetAlpha - 0.01;
	float targetMore = targetAlpha + 0.01;
	return (textureAlpha > targetLess && textureAlpha < targetMore);
	
}

// Checks to see if part of rain texture is the background
bool check_rainBG(vec4 textureColor) {

	vec3 rainBG = vec3(0.0, 0.9, 0.0); // The green BG color of the rain texture
	
	/*/ Slightly extends range for green color value
		- Does this so green BG doesn't appear when changing brightness or when it's thundering rain 
		- Also does this to omit green BG for how rainColor vec4 is calculated
	*/
	vec3 targetLess = rainBG - 0.20;
	vec3 targetMore = rainBG + 0.20;	
	return (textureColor.r == rainBG.r && textureColor.g > targetLess.g && textureColor.g < targetMore.g && textureColor.b == rainBG.b);
	
}