import os
import json

# Текущая папка (исходная)
source_folder = os.getcwd()
# Папка назначения
destination_folder = os.path.join(source_folder, 'out')

# Создаем папку назначения, если ее нет
os.makedirs(destination_folder, exist_ok=True)

# Проходим по всем файлам в исходной папке
for filename in os.listdir(source_folder):
    if filename.endswith('.png'):
        # Имя файла без расширения
        file_name_without_extension = os.path.splitext(filename)[0]
        
        # Создаем содержимое нового JSON файла
        new_content = {
            "parent": "item/handheld",
            "textures": {
                "layer0": f"item/{file_name_without_extension}"
            }
        }
        
        # Путь к новому файлу
        new_file_path = os.path.join(destination_folder, filename.replace('.png', '') + '.json')
        
        # Записываем содержимое в новый файл
        with open(new_file_path, 'w') as new_file:
            json.dump(new_content, new_file, indent=4)

print("Файлы успешно созданы в папке out.")
