#version 150

#moj_import <fog.glsl>
#moj_import <rain_utils.glsl>
#moj_import <light.glsl>

in vec3 Position;
in vec2 UV0;
in vec4 Color;
in ivec2 UV2;

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform int FogShape;

out float vertexDistance;
out vec2 texCoord0;
out vec4 vertexColor;
out vec4 lightColor;

out float isRain;
out float rainAlpha;

// Transforms matrix for rain particles only
mat4 mat_xform() {

	float rot_x = 15.0; // rotates rain on x axis in euler degrees
	float pos_z = -0.2; // shifts over rain for better placement
	float scale = 1.0; // value to scale rain
	
	float pi = 3.1415;
	float rot_x_radians = rot_x * (pi / 180); // angles to radians
	
	/*/ Transformation matrices
			Modifies rotation, position, and scale for rain
			Resources:
			- https://learnopengl.com/Getting-started/Transformations
			- https://forum.gamemaker.io/index.php?threads/solved-3d-rotations-with-a-shader-matrix-or-a-matrix-glsl-es.61064/
	*/
	mat4 rotMat = mat4( 1.0, 0.0, 0.0, 0.0,
						0.0, cos(rot_x_radians), sin(rot_x_radians), 0.0,
						0.0, -sin(rot_x_radians), cos(rot_x_radians), 0.0,
						0.0, 0.0, 0.0, 1.0);
						
	mat4 posMat = mat4(1.0, 0.0, 0.0, 0.0,
					   0.0, 1.0, 0.0, 0.0,
					   0.0, 0.0, 1.0, pos_z,
					   0.0, 0.0, 0.0, 1.0);
					   
	mat4 scaleMat = mat4(scale, 0.0, 0.0, 0.0,
						 0.0, scale, 0.0, 0.0,
						 0.0, 0.0, scale, 0.0,
						 0.0, 0.0, 0.0, 1.0);
						 
	return (posMat * rotMat * scaleMat); // combines into one final matrix (matrix order operation MATTERS!)
}

void main() {
	
	// gets transform matrix for rain
	mat4 xformMat = mat_xform();
	
    texCoord0 = UV0;
	float alpha = textureLod(Sampler0, texCoord0, 0.0).a * 255.0; // gets alpha from particle texture
	
	if (check_alpha(alpha, 97.0)) { // 38% opacity * 255 ~= 97.0
		/*/ Is Rain Particle
			Applies transform matrix to tilt rain
		*/
		
		gl_Position = ProjMat * ModelViewMat * xformMat * vec4(Position, 1.0);
		isRain = 1; // Bool for fragment shader
		rainAlpha = alpha; // Rain's alpha
	}
	else {
		gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0); // vanilla matrix projection
	}

    vertexDistance = fog_distance(Position, FogShape);
    vertexColor = Color;
	lightColor = minecraft_sample_lightmap(Sampler2, UV2);
}
