#version 150

uniform sampler2D Sampler0;
uniform vec4 ColorModulator;
uniform vec2 ScreenSize;

in vec2 texCoord0;

out vec4 fragColor;

flat in int isCompass;

#define COMPASS_WIDTH 480
#define COMPASS_WIDTH_MIN 480
#define COMPASS_WIDTH_MAX 1440

#define COMPASS_CENTER 960

#define TRANSPARENCY_SIZE 0.0

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    if (color.a < 0.1) discard;
    
	if (isCompass == 1) {
		float fragCoord = (gl_FragCoord.x/ScreenSize.x)*100;
		
		float scrSize = ScreenSize.x/1920;
		
		float compassWidth = 480*scrSize;
		float transSize = 1.3*(scrSize);
		float compassCenter = ScreenSize.x/2;

        if (!(fragCoord < 75 && fragCoord > 25)) { 
			discard;
        } else {
            // Вычисляем расстояние от текущего пикселя до центра диапазона
            float distance_to_center = abs((gl_FragCoord.x - compassCenter)*scrSize);
            
            // Вычисляем значение прозрачности на основе расстояния до центра
            float transparency = transSize - clamp(distance_to_center / compassWidth, 0.0, 1.0);
            
            // Устанавливаем прозрачность
            color.a = clamp(transparency, 0.0, 1.0);
        }
	}

	fragColor = color * ColorModulator;
}