#version 150

in vec3 Position;
in vec2 UV0;

uniform sampler2D Sampler0;
uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;
uniform vec2 ScreenSize;

out vec2 texCoord0;
flat out int isCompass;

const vec2[4] corners = vec2[4](vec2(0, 1), vec2(1, 1), vec2(1, 0), vec2(0, 0));
vec2 corner = corners[(gl_VertexID+3) % 4];

#define COMPASS_HEIGHT 18.0
#define COMPASS_WIDTH 1948.0
 
#define COMPASS_OFFSET_X -188.0
#define COMPASS_OFFSET_Y 11.0

#define PI 3.14159265
#define EQ(a,b) (length(a - b) < 0.002)

#define HH_VERSION 3
#define HH_OFFSET 13

float convertAngle(float angle, float sign) {
    float signedAngle = angle * sign; // Применяем знак к углу
    return mod(signedAngle + 360.0, 360.0);
}

float reflectAzimuth(float azimuth) {
    float azimuthRadians = radians(azimuth);
    float reflectedAzimuthRadians = atan(sin(azimuthRadians), -cos(azimuthRadians));
    float reflectedAzimuth = degrees(reflectedAzimuthRadians);
    return mod(reflectedAzimuth, 360.0);
}

float getYaw() {
	float yaw = acos(clamp(-IViewRotMat[0][0], -1.0, 1.0)) * 180.0 / PI;
	yaw = convertAngle(yaw, float(sign(IViewRotMat[0][2])));
	yaw = reflectAzimuth(yaw);
    return yaw;
}

void main() {
	vec3 pos = Position;
	texCoord0 = UV0;
	
	//compass
	if (EQ(texture(Sampler0, UV0 - corner / textureSize(Sampler0, 0)).rgb, vec3(10.0/255.0, 10.0/255.0, 10.0/255.0))) { 
		pos.xy += corner * vec2(COMPASS_WIDTH, COMPASS_HEIGHT) + vec2(COMPASS_OFFSET_X, COMPASS_OFFSET_Y);
		
		isCompass = 1;
		float yaw = getYaw();
	 
		pos.x -= ((yaw/360)*1576); // yaw 61
		//pos.x -= 1637; // yaw
		
		vec2 pixel = vec2(ProjMat[0][0], ProjMat[1][1]) / 2.0;
		int guiScale = int(round(pixel.x / (1 / ScreenSize.x)));
		vec2 guiSize = ScreenSize / guiScale;
		
		float scaleX = 0.75;
		float scaleY = 0.75;
		float xOffset = int(guiSize.x * (-50.0/100));
		float yOffset = int(guiSize.y * (100/100));
		
		pos.y -= HH_OFFSET+COMPASS_OFFSET_Y;
		pos.x -= (guiSize.x * 0.5);

		pos.x *= scaleX;
		pos.y *= scaleY;

		pos.y += guiSize.y;
		// force align guiScale 3
		if (guiScale == 3) {
			pos.x += 1.45;
		}

		pos -= vec3(xOffset, yOffset, 0.0);
		
		gl_Position = ProjMat * ModelViewMat * vec4(pos, 1.0);
		return;
	}
	//compass
	
	
	//move hotbar
	if (EQ(texture(Sampler0, UV0 - corner / textureSize(Sampler0, 0)).rgb, vec3(10.0/255.0, 0.0/255.0, 10.0/255.0))) { 
        pos.y += -16.0;
		gl_Position = ProjMat * ModelViewMat * vec4(pos, 1.0);
		return;
    }
	//move hotbar
	
	gl_Position = ProjMat * ModelViewMat * vec4(pos, 1.0);
}