#version 150

in vec3 Position;
in vec4 Color;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;

out vec4 vertexColor;

void main() {
	vec3 pos = Position;
	
	if (pos.z > 0 && pos.z < 120) {
		pos.y += -18.0;
	}

    gl_Position = ProjMat * ModelViewMat * vec4(pos, 1.0);
    vertexColor = Color;
}
