#version 150

#moj_import <fog.glsl>
#moj_import <light.glsl>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV2;

uniform sampler2D Sampler0;
uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;
uniform vec2 ScreenSize;
uniform int FogShape;

out float vertexDistance;
out vec4 vertexColor;
out vec2 texCoord0;
out vec2 texCoord1;
out vec2 texCoord2;
out float minimap;
out float keepEdges;
out float transition;
out float fullscreenMinimap;
out float sx, sy;

#define HH_VERSION 3
#define HH_OFFSET 10

#moj_import <minimap/vertex_util.glsl>

bool isAt(int offset, int vID, int pos) {
	return (((vID == 1 || vID == 2) && offset == pos) || ((vID == 0 || vID == 3) && offset == (pos+8)));
}

// Function to convert a vertical ascent into a ID.
float get_id(float offset) {
    if (offset <= 0.0)
        return 0.0;
    return trunc(offset/1000.0);
}

void main() {
    vec3 pos = Position;

	//minimap
	vec4 vertex = vec4(Position, 1.0);
    vec4 vcolor = Color * texelFetch(Sampler2, UV2 / 16, 0);
    gl_Position = ProjMat * ModelViewMat * vertex;
    vertexDistance = length((ModelViewMat * vertex).xyz);

    #moj_import <minimap/vertex_main.glsl>	
	//minimap
	
    if (Position.z >= 30 && Position.z <= 100.1) {
		pos.y += -18.0;
		gl_Position = ProjMat * ModelViewMat * vec4(pos, 1);
		return;
	}

    if (Position.z >= 200 && Position.z <= 200.1) {
		pos.y += -16.0;
		gl_Position = ProjMat * ModelViewMat * vec4(pos, 1);
		return;
	}

	//hide xp numbers
	vec2 pixel = vec2(ProjMat[0][0], ProjMat[1][1]) / 2.0;
	int guiScale = int(round(pixel.x / (1 / ScreenSize.x)));
	vec2 guiSize = ScreenSize / guiScale;
	int vID = gl_VertexID % 4;
	int offset = int(round(guiSize.y - Position.y));
	
	// offset xp text
	if(Position.z == 0.0 // z location is always 0 
		&& ((length(Color.rgb - vec3(0.501, 1.0, 0.125)) < 0.002 && (isAt(offset, vID, 26) || isAt(offset, vID, 27))) // the bright text starts 27 pixels from the bottom, sometimes at 26
		|| (length(Color.rgb - vec3(0.0, 0.0, 0.0)) < 0.002 && (isAt(offset, vID, 25) || isAt(offset, vID, 26) || isAt(offset, vID, 27) || isAt(offset, vID, 28))))) { // the darker background consists out of 3 elements (26,27,28), sometimes (25,26,27)
        
        /** Reposition (Remove up to Reposition End if unnecessary)**/
		pos += vec3(0.0,50.0,0.0); // apply an offset
        /* Reposition End */
		
		gl_Position = ProjMat * ModelViewMat * vec4(pos, 1.0);
	}
	//hide xp numbers

    vertexDistance = fog_distance(ModelViewMat, IViewRotMat * Position, FogShape);
    vertexColor = Color;
    texCoord0 = UV0;

    float id = get_id((round(HH_OFFSET - Position.y)) * -1);

    // Detect if GUI text.
    if (id > 99 && Color.a != 0.0) {
        float yOffset = 0.0;
        float xOffset = 0.0;
        int layer = 0;
        vec2 scale = vec2(1, 1);
        bool outlined = false;

        switch (int(id)) {
            case 100:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-25;
                yOffset = int(guiSize.y * (0.0/100))+41;
                layer = 0;
                break;
            case 101:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-25;
                yOffset = int(guiSize.y * (0.0/100))+44;
                layer = 0;
                break;
            case 102:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-193;
                yOffset = int(guiSize.y * (0.0/100))+42;
                layer = 0;
                break;
            case 103:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-193;
                yOffset = int(guiSize.y * (0.0/100))+45;
                layer = 0;
                break;
            case 104:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-193;
                yOffset = int(guiSize.y * (0.0/100))+50;
                layer = 0;
                break;
            case 105:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-193;
                yOffset = int(guiSize.y * (0.0/100))+53;
                layer = 0;
                break;
            case 106:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-35;
                yOffset = int(guiSize.y * (0.0/100))+46;
                layer = 0;
                break;
            case 107:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-35;
                yOffset = int(guiSize.y * (0.0/100))+49;
                layer = 0;
                break;
            case 108:
                scale.x = 0.05;
                scale.y = 0.05;
                xOffset = int(guiSize.x * (-0.0/100))-26;
                yOffset = int(guiSize.y * (0.0/100))+50;
                layer = 0;
                break;
            case 109:
                scale.x = 0.05;
                scale.y = 0.05;
                xOffset = int(guiSize.x * (-0.0/100))-26;
                yOffset = int(guiSize.y * (0.0/100))+47;
                layer = 0;
                break;
            case 110:
                scale.x = 0.69;
                scale.y = 0.55;
                xOffset = int(guiSize.x * (-0.0/100))-106;
                yOffset = int(guiSize.y * (0.0/100))+52;
                layer = -1;
                break;
            case 111:
                scale.x = 0.57;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-123;
                yOffset = int(guiSize.y * (0.0/100))+25;
                layer = 0;
                break;
            case 112:
                scale.x = 0.63;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-0.0/100))-133;
                yOffset = int(guiSize.y * (0.0/100))+25;
                layer = 0;
                break;
            case 113:
                xOffset = int(guiSize.x * (-100.0/100))+2;
                yOffset = int(guiSize.y * (100.0/100))-12;
                layer = 0;
                outlined = true;
                break;
            case 114:
                xOffset = int(guiSize.x * (-100.0/100))+2;
                yOffset = int(guiSize.y * (100.0/100))-9;
                layer = 0;
                outlined = true;
                break;
            case 115:
                xOffset = int(guiSize.x * (-100.0/100))+2;
                yOffset = int(guiSize.y * (100.0/100))-2;
                layer = 0;
                outlined = true;
                break;
            case 116:
                xOffset = int(guiSize.x * (-100.0/100))+2;
                yOffset = int(guiSize.y * (100.0/100))+1;
                layer = 0;
                outlined = true;
                break;
            case 117:
                xOffset = int(guiSize.x * (-0.0/100))-2;
                yOffset = int(guiSize.y * (100.0/100))-2;
                layer = 0;
                outlined = true;
                break;
            case 118:
                xOffset = int(guiSize.x * (-0.0/100))-2;
                yOffset = int(guiSize.y * (100.0/100))+1;
                layer = 0;
                outlined = true;
                break;
            case 119:
                xOffset = int(guiSize.x * (-0.0/100))-2;
                yOffset = int(guiSize.y * (100.0/100))-12;
                layer = 0;
                outlined = true;
                break;
            case 120:
                xOffset = int(guiSize.x * (-0.0/100))-2;
                yOffset = int(guiSize.y * (100.0/100))-9;
                layer = 0;
                outlined = true;
                break;
            case 121:
                scale.x = 0.1;
                scale.y = 0.1;
                xOffset = int(guiSize.x * (-100.0/100))+25;
                yOffset = int(guiSize.y * (0.0/100))+33;
                layer = 0;
                break;
            case 122:
                scale.x = 0.4;
                scale.y = 0.4;
                xOffset = int(guiSize.x * (-100.0/100))+65;
                yOffset = int(guiSize.y * (0.0/100))+29;
                layer = 0;
                break;
            case 123:
                scale.x = 0.4;
                scale.y = 0.4;
                xOffset = int(guiSize.x * (-100.0/100))+120;
                yOffset = int(guiSize.y * (0.0/100))+29;
                layer = 0;
                break;
            case 124:
                scale.x = 0.1;
                scale.y = 0.1;
                xOffset = int(guiSize.x * (-100.0/100))+83;
                yOffset = int(guiSize.y * (0.0/100))+35;
                layer = 0;
                break;
            case 125:
                scale.x = 0.1;
                scale.y = 0.1;
                xOffset = int(guiSize.x * (-100.0/100))+50;
                yOffset = int(guiSize.y * (0.0/100))+35;
                layer = 0;
                break;
            case 126:
                scale.x = 0.1;
                scale.y = 0.1;
                xOffset = int(guiSize.x * (-0.0/100))-35;
                yOffset = int(guiSize.y * (0.0/100))+30;
                layer = 0;
                break;
            case 127:
                scale.x = 0.1;
                scale.y = 0.1;
                xOffset = int(guiSize.x * (-100.0/100))+105;
                yOffset = int(guiSize.y * (0.0/100))+35;
                layer = 0;
                break;
            case 128:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+62;
                layer = 0;
                break;
            case 129:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+65;
                layer = 0;
                break;
            case 130:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+73;
                layer = 0;
                outlined = true;
                break;
            case 131:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+76;
                layer = 0;
                outlined = true;
                break;
            case 132:
                scale.x = 0.07;
                scale.y = 0.065;
                xOffset = int(guiSize.x * (-100.0/100))+187;
                yOffset = int(guiSize.y * (0.0/100))+74;
                layer = 0;
                break;
            case 133:
                scale.x = 0.73;
                scale.y = 0.67;
                xOffset = int(guiSize.x * (-100.0/100))+34;
                yOffset = int(guiSize.y * (0.0/100))+75;
                layer = -1;
                break;
            case 134:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+87;
                layer = 0;
                break;
            case 135:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+90;
                layer = 0;
                break;
            case 136:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+98;
                layer = 0;
                outlined = true;
                break;
            case 137:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+101;
                layer = 0;
                outlined = true;
                break;
            case 138:
                scale.x = 0.07;
                scale.y = 0.065;
                xOffset = int(guiSize.x * (-100.0/100))+187;
                yOffset = int(guiSize.y * (0.0/100))+99;
                layer = 0;
                break;
            case 139:
                scale.x = 0.73;
                scale.y = 0.67;
                xOffset = int(guiSize.x * (-100.0/100))+34;
                yOffset = int(guiSize.y * (0.0/100))+100;
                layer = -1;
                break;
            case 140:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+112;
                layer = 0;
                break;
            case 141:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+115;
                layer = 0;
                break;
            case 142:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+123;
                layer = 0;
                outlined = true;
                break;
            case 143:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+126;
                layer = 0;
                outlined = true;
                break;
            case 144:
                scale.x = 0.07;
                scale.y = 0.065;
                xOffset = int(guiSize.x * (-100.0/100))+187;
                yOffset = int(guiSize.y * (0.0/100))+124;
                layer = 0;
                break;
            case 145:
                scale.x = 0.73;
                scale.y = 0.67;
                xOffset = int(guiSize.x * (-100.0/100))+34;
                yOffset = int(guiSize.y * (0.0/100))+125;
                layer = -1;
                break;
            case 146:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+137;
                layer = 0;
                break;
            case 147:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+140;
                layer = 0;
                break;
            case 148:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+148;
                layer = 0;
                outlined = true;
                break;
            case 149:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+151;
                layer = 0;
                outlined = true;
                break;
            case 150:
                scale.x = 0.07;
                scale.y = 0.065;
                xOffset = int(guiSize.x * (-100.0/100))+187;
                yOffset = int(guiSize.y * (0.0/100))+149;
                layer = 0;
                break;
            case 151:
                scale.x = 0.73;
                scale.y = 0.67;
                xOffset = int(guiSize.x * (-100.0/100))+34;
                yOffset = int(guiSize.y * (0.0/100))+150;
                layer = -1;
                break;
            case 152:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+162;
                layer = 0;
                break;
            case 153:
                scale.x = 0.75;
                scale.y = 0.75;
                xOffset = int(guiSize.x * (-100.0/100))+218;
                yOffset = int(guiSize.y * (0.0/100))+165;
                layer = 0;
                break;
            case 154:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+173;
                layer = 0;
                outlined = true;
                break;
            case 155:
                xOffset = int(guiSize.x * (-100.0/100))+221;
                yOffset = int(guiSize.y * (0.0/100))+176;
                layer = 0;
                outlined = true;
                break;
            case 156:
                scale.x = 0.07;
                scale.y = 0.065;
                xOffset = int(guiSize.x * (-100.0/100))+187;
                yOffset = int(guiSize.y * (0.0/100))+174;
                layer = 0;
                break;
            case 157:
                scale.x = 0.73;
                scale.y = 0.67;
                xOffset = int(guiSize.x * (-100.0/100))+34;
                yOffset = int(guiSize.y * (0.0/100))+175;
                layer = -1;
                break;
            case 158:
                scale.x = 0.1;
                scale.y = 0.1;
                xOffset = int(guiSize.x * (-0.0/100))-36;
                yOffset = int(guiSize.y * (0.0/100))+30;
                layer = 0;
                break;
            case 159:
                scale.x = 0.12;
                scale.y = 0.12;
                xOffset = int(guiSize.x * (-100.0/100))+190;
                yOffset = int(guiSize.y * (0.0/100))+37;
                layer = 0;
                break;
            case 160:
                scale.x = 0.12;
                scale.y = 0.12;
                xOffset = int(guiSize.x * (-100.0/100))+140;
                yOffset = int(guiSize.y * (0.0/100))+36;
                layer = 0;
                break;
            case 161:
                scale.x = 0.1;
                scale.y = 0.1;
                xOffset = int(guiSize.x * (-0.0/100))-19;
                yOffset = int(guiSize.y * (0.0/100))+30;
                layer = 0;
                break;
            case 162:
                scale.x = 0.1;
                scale.y = 0.1;
                xOffset = int(guiSize.x * (-0.0/100))-34;
                yOffset = int(guiSize.y * (0.0/100))+30;
                layer = 0;
                break;
            case 163:
                scale.x = 0.12;
                scale.y = 0.12;
                xOffset = int(guiSize.x * (-100.0/100))+165;
                yOffset = int(guiSize.y * (0.0/100))+37;
                layer = 0;
                break;
        }

        // -90.0 is required for forge comp
        if ((Position.z != 0.0 && Position.z != -90.0) || outlined) {
            pos.y -= (id*1000) + 500 + HH_OFFSET;
            pos.x -= (guiSize.x * 0.5);

            pos.x *= scale.x;
            pos.y *= scale.y;

            pos.y += guiSize.y;
            // force align guiScale 3
            if (guiScale == 3) {
                pos.x += 1.45;
            }

            pos -= vec3(xOffset, yOffset, 0.0);
            pos.z += layer;
        }
		
		gl_Position = ProjMat * ModelViewMat * vec4(pos, 1);
    } 	
}
