#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;
uniform float GameTime;

uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

in float vertexDistance;
in vec4 vertexColor;
in vec4 vertexColor2;
in vec4 lightColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord;
in vec2 texCoord0;
in vec4 normal;
in vec3 Pos;
in float transition;

flat in int isCustom;
flat in int isGUI;
flat in int isHand;
flat in int noshadow;

// custom values
flat in int skinEffects;
flat in vec4 data1Color;
flat in vec4 data2Color;
flat in int isFace;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord);
    vec4 color2 = texture(Sampler0, texCoord0);

    //custom lighting
    #define ENTITY
    #define HEAD
    #moj_import<objmc_light.glsl>

    if (color.a < 0.01) discard;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
	
	
	// replace flash color
	vec4 oColor = overlayColor; // get vanilla flash color
	
	// replace face texture => blinking
	vec2 texSize = textureSize(Sampler0,0);
	if(skinEffects == 1 && isFace == 1 && (0.1 > mod(GameTime * 1200, (data2Color.r * 5.0)) / (data2Color.r * 5.0)) && texCoord0.y < 16.0/texSize.y && data2Color.a == 1.0) {  // check for skin effects enabled, is face, gametime for blinkin, and finally if a timer for blinking is set
		color2 = texture(Sampler0, texCoord0 + vec2(16.0/texSize.x, -8.0/texSize.y)); //offset from where it reads the texture
	}
	
	// vanilla stuff #2, mix all the colors the proper way
    color *= vertexColor2 * ColorModulator;
    color.rgb = mix(oColor.rgb, color2.rgb, oColor.a);
    color *= lightMapColor;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}